/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.handler;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.creeperhost.chickens.ChickensMod;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ItemHolder {
    private String source = null;
    private String itemID;
    private CompoundTag nbtData;
    private JsonObject nbtRawJson;
    private boolean isComplete = false;
    private ItemStack stack = ItemStack.f_41583_;
    private int stackSize = 1;
    public static HashMap<String, Integer> ErroredItems = new HashMap();
    Gson gson = new Gson();

    public ItemHolder() {
        this.itemID = Items.f_41852_.getRegistryName().toString();
        this.nbtData = null;
        this.stack = ItemStack.f_41583_;
    }

    public ItemHolder(Item itemIn) {
        this.itemID = itemIn.getRegistryName().toString();
        this.nbtData = null;
        this.stack = ItemStack.f_41583_;
    }

    public ItemHolder(ItemStack stackIn, boolean isFinal) {
        this.itemID = stackIn.m_41720_().getRegistryName().toString();
        this.stack = stackIn;
        this.nbtData = stackIn.m_41782_() ? stackIn.m_41783_() : null;
        this.stackSize = stackIn.m_41613_();
        this.isComplete = isFinal;
    }

    public ItemHolder(String itemID, int metaID, int qty) {
        this.itemID = itemID;
        this.nbtData = null;
    }

    public ItemHolder(String itemID, String nbt) {
        this.itemID = itemID;
        try {
            CompoundTag compoundTag;
            this.nbtData = compoundTag = TagParser.m_129359_((String)nbt);
        }
        catch (Exception e) {
            this.nbtData = null;
            e.printStackTrace();
        }
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public String getSource() {
        return this.source;
    }

    public ItemHolder setSource(String sourceIn) {
        this.source = sourceIn;
        return this;
    }

    @Nullable
    public Item getItem() {
        return (Item)Registry.f_122827_.m_7745_(new ResourceLocation(this.itemID));
    }

    public int getStackSize() {
        return !this.stack.m_41619_() ? this.stack.m_41613_() : this.stackSize;
    }

    public int getAmount() {
        return this.stackSize;
    }

    public ItemStack getStack() {
        if (!this.isComplete) {
            Item item = this.getItem();
            if (item != null) {
                this.stack = new ItemStack((ItemLike)this.getItem(), this.getAmount());
                if (this.nbtData != null && !this.nbtData.m_128456_()) {
                    this.stack.m_41751_(this.nbtData);
                }
                this.isComplete = true;
            } else {
                this.handleItemNotFound();
            }
        }
        return this.stack.m_41777_();
    }

    private void handleItemNotFound() {
        if (!ErroredItems.containsKey(this.itemID)) {
            ErroredItems.put(this.itemID, 1);
        } else {
            ErroredItems.replace(this.itemID, ErroredItems.get(this.itemID) + 1);
        }
        if (ErroredItems.get(this.itemID) <= 3) {
            ChickensMod.LOGGER.error("Could not find specfied Item: [" + this.itemID + "]" + (String)(this.hasSource() ? " | Source: [" + this.getSource() + "]" : "") + " | Dropping Default Item: [" + this.stack.m_41611_() + "]");
            if (ErroredItems.get(this.itemID) == 3) {
                ChickensMod.LOGGER.error("Will silent error this itemID: [" + this.itemID + "]");
            }
        }
    }

    public ItemHolder readJsonObject(JsonObject data) throws NumberFormatException {
        this.itemID = data.has("itemID") ? data.get("itemID").getAsString() : Items.f_41852_.getRegistryName().toString();
        this.stackSize = data.has("qty") ? data.get("qty").getAsInt() : 1;
        this.nbtRawJson = data.has("nbt") ? data.get("nbt").getAsJsonObject() : null;
        return this;
    }

    public JsonObject writeJsonObject(JsonObject data) throws NumberFormatException {
        data.addProperty("itemID", this.itemID);
        if (this.stackSize > 1) {
            data.addProperty("qty", (Number)this.getStackSize());
        }
        if (this.nbtData != null && !this.nbtData.m_128456_()) {
            JsonElement element = (JsonElement)this.gson.fromJson(this.nbtData.toString(), JsonElement.class);
            data.add("nbt", (JsonElement)element.getAsJsonObject());
        }
        return data;
    }

    public String toString() {
        return this.itemID + ":" + this.stackSize + (String)(this.nbtData != null ? ":" + this.nbtData.toString() : "");
    }
}

